<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('speciality_id', 'doctor_id', 'name', 'phone', 'day', 'time');

    public function doctor()
    {
        return $this->belongsTo('App\Models\Doctor');
    }

    public function speciality()
    {
        return $this->belongsTo('App\Models\Speciality');
    }

}